import { CreateUserDto } from './dto/create-user.dto';
import { UpdateUserDto } from './dto/update-user.dto';
import { User } from './entities/user.entity';
import { Repository } from 'typeorm';
import { JwtService } from '@nestjs/jwt';
import { UserRole } from './user-role.enum';
import { CreateUserTechnicalDto } from './dto/create-tecnico.dto';
export declare class UserService {
    private usersRepository;
    private jwtService;
    constructor(usersRepository: Repository<User>, jwtService: JwtService);
    create(createUserDto: CreateUserDto): Promise<{
        user: User;
        accessToken: string;
    }>;
    update(id: number, updateUserDto: UpdateUserDto): Promise<User>;
    createTechnical(createTecnicoDto: CreateUserTechnicalDto): Promise<{
        tecnico: User;
        accessToken: string;
    }>;
    createColaborator(createColaboratorDto: CreateUserTechnicalDto): Promise<{
        colaborador: User;
        accessToken: string;
    }>;
    login(email: string, password: string): Promise<{
        user: User;
        accessToken: string;
    }>;
    remove(id: number): Promise<import("typeorm").DeleteResult>;
    getAllUsersClients(): Promise<any[]>;
    getAllUsersTechnical(): Promise<User[]>;
    getAllUsersColaborator(): Promise<User[]>;
    getMe(id: number): Promise<{
        id: number;
        name: string;
        email: string;
        cnpj: string;
        razaoSocial: string;
        telefone: string;
        isActive: boolean;
        role: UserRole;
        requiresSubscription: boolean;
        workDays: string[];
        workShiftStart: string;
        workShiftEnd: string;
        registrationDate: Date;
        equipamentos: import("../equipamento/entities/equipamento.entity").Equipamento[];
        chamados: import("../chamado/entities/chamado.entity").Chamado[];
        registrosColaborador: import("../colaborador/entities/colaborador.entity").Colaborador[];
        colaboradoresDaEmpresa: import("../colaborador/entities/colaborador.entity").Colaborador[];
        despesas: import("../colaborador/entities/despesas.entity").Despesas[];
    }>;
}
