import { CreateEquipamentoDto } from './dto/create-equipamento.dto';
import { UpdateEquipamentoDto } from './dto/update-equipamento.dto';
import { Equipamento } from './entities/equipamento.entity';
import { User } from 'src/user/entities/user.entity';
import { EquipamentoStatus } from './equipamento-role.enum';
import 'dotenv/config';
import { Chamado } from 'src/chamado/entities/chamado.entity';
import { RespostaChecklistTecnico } from 'src/chamado/entities/resposta-checklist-tecnico.entity';
export declare class EquipamentoService {
    private equipamentoRepository;
    private userRepository;
    private chamadoRepository;
    private checklistTecnicoRepository;
    create(createEquipamentoDto: CreateEquipamentoDto): Promise<Equipamento>;
    findAll(currentUser: User): Promise<Equipamento[] | undefined>;
    findOne(id: number): Promise<{
        chamadoAberto: {
            id: number | undefined;
            horaAtendimento: Date | undefined;
            horaFinalizacao: Date | undefined;
        };
        chamadosFechados: {
            id: number;
            tipo: string;
            status: string;
            horaAbertura: Date;
            horaInicioAtendimento: Date;
            horaFinalizacao: Date;
            tecnico: {
                name: string;
            } | null;
        }[];
        id: number;
        modeloCompressor: string;
        tipoGas: string;
        tipoOleo: string;
        tipoEvaporador: string;
        tipoCondensador: string;
        tipoValvula: string;
        tensao: string;
        aplicacao: string;
        qrcode: string;
        isAtivo: boolean;
        status: EquipamentoStatus;
        user: User | null;
        visitas: import("../colaborador/entities/visitaAgendada.entity").VisitaAgendada[];
    }>;
    findByUser(userid: number): Promise<Equipamento[]>;
    updateRealTime(id: number): Promise<RespostaChecklistTecnico[]>;
    update(id: number, updateEquipamentoDto: UpdateEquipamentoDto): Promise<import("typeorm").UpdateResult>;
    remove(id: number): Promise<import("typeorm").DeleteResult>;
    generateQRCode(id: number): Promise<string>;
    historico(id: number, correntUser: User): Promise<Chamado[]>;
    ativar(id: number): Promise<void>;
    desativar(id: number): Promise<void>;
}
