"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EquipamentoController = void 0;
const common_1 = require("@nestjs/common");
const equipamento_service_1 = require("./equipamento.service");
const create_equipamento_dto_1 = require("./dto/create-equipamento.dto");
const update_equipamento_dto_1 = require("./dto/update-equipamento.dto");
const passport_1 = require("@nestjs/passport");
const roles_guard_1 = require("../auth/guards/roles.guard");
const current_user_decorator_1 = require("../auth/decorators/current-user.decorator");
const user_role_enum_1 = require("../user/user-role.enum");
const user_entity_1 = require("../user/entities/user.entity");
let EquipamentoController = class EquipamentoController {
    equipamentoService;
    constructor(equipamentoService) {
        this.equipamentoService = equipamentoService;
    }
    create(createEquipamentoDto) {
        return this.equipamentoService.create(createEquipamentoDto);
    }
    findAll(currentUser) {
        return this.equipamentoService.findAll(currentUser);
    }
    findOne(id) {
        return this.equipamentoService.findOne(+id);
    }
    async findByUser(userid) {
        return this.equipamentoService.findByUser(+userid);
    }
    async updateRealTime(id) {
        return this.equipamentoService.updateRealTime(+id);
    }
    async generateQRCode(id, res) {
        const qrcodeBuffer = await this.equipamentoService.generateQRCode(+id);
        res.setHeader('Content-Type', 'image/png');
        res.setHeader('Content-Disposition', `inline; filename="qrcode-equipamento-${id}.png"`);
        res.send(qrcodeBuffer);
    }
    async historico(id, correntUser) {
        return this.equipamentoService.historico(+id, correntUser);
    }
    update(id, updateEquipamentoDto) {
        return this.equipamentoService.update(+id, updateEquipamentoDto);
    }
    ativar(id) {
        return this.equipamentoService.ativar(+id);
    }
    desativar(id) {
        return this.equipamentoService.desativar(+id);
    }
    remove(id) {
        return this.equipamentoService.remove(+id);
    }
};
exports.EquipamentoController = EquipamentoController;
__decorate([
    (0, common_1.Post)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_equipamento_dto_1.CreateEquipamentoDto]),
    __metadata("design:returntype", void 0)
], EquipamentoController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN, user_role_enum_1.UserRole.TECHNICAL, user_role_enum_1.UserRole.COMMON_USER),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", void 0)
], EquipamentoController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], EquipamentoController.prototype, "findOne", null);
__decorate([
    (0, common_1.Get)(':userid/user-equipament'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __param(0, (0, common_1.Param)('userid')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], EquipamentoController.prototype, "findByUser", null);
__decorate([
    (0, common_1.Get)(':id/realtime'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], EquipamentoController.prototype, "updateRealTime", null);
__decorate([
    (0, common_1.Get)(':id/qrcode'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN, user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], EquipamentoController.prototype, "generateQRCode", null);
__decorate([
    (0, common_1.Get)(':id/historico'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN, user_role_enum_1.UserRole.TECHNICAL, user_role_enum_1.UserRole.COMMON_USER),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, user_entity_1.User]),
    __metadata("design:returntype", Promise)
], EquipamentoController.prototype, "historico", null);
__decorate([
    (0, common_1.Patch)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_equipamento_dto_1.UpdateEquipamentoDto]),
    __metadata("design:returntype", void 0)
], EquipamentoController.prototype, "update", null);
__decorate([
    (0, common_1.Patch)(':id/ativar'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], EquipamentoController.prototype, "ativar", null);
__decorate([
    (0, common_1.Patch)(':id/desativar'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], EquipamentoController.prototype, "desativar", null);
__decorate([
    (0, common_1.Delete)(':id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", void 0)
], EquipamentoController.prototype, "remove", null);
exports.EquipamentoController = EquipamentoController = __decorate([
    (0, common_1.Controller)('equipamento'),
    __metadata("design:paramtypes", [equipamento_service_1.EquipamentoService])
], EquipamentoController);
//# sourceMappingURL=equipamento.controller.js.map