"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DashboardController = void 0;
const common_1 = require("@nestjs/common");
const dashboard_service_1 = require("./dashboard.service");
const passport_1 = require("@nestjs/passport");
const roles_guard_1 = require("../auth/guards/roles.guard");
const current_user_decorator_1 = require("../auth/decorators/current-user.decorator");
const user_entity_1 = require("../user/entities/user.entity");
const user_role_enum_1 = require("../user/user-role.enum");
let DashboardController = class DashboardController {
    dashboardService;
    constructor(dashboardService) {
        this.dashboardService = dashboardService;
    }
    async findAll(currentUser) {
        const equipamento = await this.dashboardService.CountEquipament(currentUser);
        const chamados = await this.dashboardService.chamadosPendentes(currentUser);
        const tipo = await this.dashboardService.typeChamado(currentUser);
        return { equipamentos: equipamento, chamados: chamados, tipos: tipo };
    }
    async findAllAdmin() {
        const tecnicos = await this.dashboardService.atividadeTecnicoEsseMes();
        const tecnicos6 = await this.dashboardService.atividadeTecnicoSeisMeses();
        const chamados = await this.dashboardService.osPendente();
        const clientes = await this.dashboardService.totalCliente();
        const tecnicosTotal = await this.dashboardService.totalTecnico();
        const chamadosTotal = await this.dashboardService.totalOsPendente();
        const equipamentos = await this.dashboardService.totalEquipamentosMonitorados();
        const tipo = await this.dashboardService.chamadoPorTipoDeEquipamento();
        return { tecnicos: tecnicos, tecnicosSeisMeses: tecnicos6, chamadosPendentes: chamados, totalClientes: clientes, totalTecnicos: tecnicosTotal, totalOsPendentes: chamadosTotal, totalDeEquipamentosMonitorados: equipamentos, chamadosPorTipo: tipo };
    }
    async findAllTecnico(currentUser) {
        const tecnicos = await this.dashboardService.atividadeTecnicoSeteDias(currentUser);
        const maquinas = await this.dashboardService.maquinasTecnico(currentUser);
        const recente = await this.dashboardService.atividadeRecente(currentUser);
        return { tecnico: tecnicos, orderServiço: maquinas, recente: recente };
    }
};
exports.DashboardController = DashboardController;
__decorate([
    (0, common_1.Get)('usuario'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.COMMON_USER),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", Promise)
], DashboardController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)('admin'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.ADMIN),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], DashboardController.prototype, "findAllAdmin", null);
__decorate([
    (0, common_1.Get)('tecnico'),
    (0, common_1.UseGuards)((0, passport_1.AuthGuard)('jwt'), roles_guard_1.RolesGuard),
    (0, current_user_decorator_1.Roles)(user_role_enum_1.UserRole.TECHNICAL),
    __param(0, (0, current_user_decorator_1.CurrentUser)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_entity_1.User]),
    __metadata("design:returntype", Promise)
], DashboardController.prototype, "findAllTecnico", null);
exports.DashboardController = DashboardController = __decorate([
    (0, common_1.Controller)('dashboard'),
    __metadata("design:paramtypes", [dashboard_service_1.DashboardService])
], DashboardController);
//# sourceMappingURL=dashboard.controller.js.map