import { CreateColaboradorDto } from './dto/create-colaborador.dto';
import { UpdateColaboradorDto } from './dto/update-colaborador.dto';
import { Repository } from 'typeorm';
import { Colaborador } from './entities/colaborador.entity';
import { User } from 'src/user/entities/user.entity';
import { RegistrosColaborador } from './entities/registroColaborador.entity';
import { CreateDespesasDto } from './dto/create-despesas.dto';
import { Despesas } from './entities/despesas.entity';
import { VisitaAgendada } from './entities/visitaAgendada.entity';
import { Equipamento } from 'src/equipamento/entities/equipamento.entity';
import { EquipamentoService } from 'src/equipamento/equipamento.service';
import { Chamado } from 'src/chamado/entities/chamado.entity';
export declare class ColaboradorService {
    private colaboradorRepository;
    private registrosColaboradorRepository;
    private despesasRepository;
    private visitaAgendadaRepository;
    private chamadoRepository;
    private userRepository;
    private readonly equipamentoService;
    private readonly s3;
    constructor(colaboradorRepository: Repository<Colaborador>, registrosColaboradorRepository: Repository<RegistrosColaborador>, despesasRepository: Repository<Despesas>, visitaAgendadaRepository: Repository<VisitaAgendada>, chamadoRepository: Repository<Chamado>, userRepository: Repository<User>, equipamentoService: EquipamentoService);
    create(currentUser: User): Promise<Colaborador | undefined>;
    findAll(date?: string): Promise<any>;
    findOne(id: number): Promise<Colaborador | null>;
    update(id: number, updateColaboradorDto: UpdateColaboradorDto): Promise<import("typeorm").UpdateResult>;
    registroColaborador(id: number, updateColaboradorDto: UpdateColaboradorDto, file?: Express.Multer.File): Promise<RegistrosColaborador>;
    remove(id: number): Promise<import("typeorm").DeleteResult>;
    linhaTempo(id: number): Promise<Colaborador | null>;
    pontoColaborador(currentUser: User): Promise<Colaborador[]>;
    historicoPonto(currentUser: User): Promise<Colaborador[]>;
    historicoPontoAdmin(id: number): Promise<{
        user: User | null;
        resultado: any;
    }>;
    despesas(createDespesasDto: CreateDespesasDto, currentUser: User, file?: Express.Multer.File): Promise<Despesas>;
    getDespesas(currentUser: User): Promise<Despesas[] | {
        user: string;
        email: string;
        id: number;
        data: Date;
        tipo: string;
        valor: number;
        status: string;
        urlArquivo: string;
    }[]>;
    aprovarDespesa(id: number): Promise<Despesas>;
    rejeitarDespesa(id: number): Promise<Despesas>;
    criarVisita(tecnicoId: number, equipamentoId: number, createColaboradorDto: CreateColaboradorDto): Promise<Chamado>;
    atualizarVisita(chamadoId: number, tecnicoId: number, equipamentoId: number, updateColaboradorDto: CreateColaboradorDto): Promise<Chamado>;
    iniciarVisitaAgendada(currentUser: User, chamadoId: number): Promise<void>;
    getVisitaAgendada(CurrentUser: User): Promise<{
        user: string;
        email: string;
        empresa: string;
        id: number;
        atividade: string;
        dataMarcada: Date;
        status: string;
        tipo: string;
        equipamento: Equipamento;
    }[] | {
        empresa: string;
        id: number;
        atividade: string;
        dataMarcada: Date;
        status: string;
        tipo: string;
        user: User;
        equipamento: Equipamento;
    }[]>;
    uploadImageToS3(file: Express.Multer.File, fileName: string): Promise<string>;
}
