import { CreateChamadoDto } from './dto/create-chamado.dto';
import { Repository } from 'typeorm';
import { Chamado } from './entities/chamado.entity';
import { EventEmitter2 } from '@nestjs/event-emitter';
import { Equipamento } from 'src/equipamento/entities/equipamento.entity';
import { RespostaChecklist } from './entities/resposta-checklist.entity';
import { User } from 'src/user/entities/user.entity';
import { RespostaChecklistTecnico } from './entities/resposta-checklist-tecnico.entity';
import { ChecklistGateway } from './checklist.gateway';
export declare class ChamadoService {
    private chamadoRepository;
    private eventEmitter;
    private equipamentoRepository;
    private respostaChecklistRepository;
    private respostaChecklistTecnicoRepository;
    private checklistGateway;
    private userRepository;
    private readonly s3;
    constructor(chamadoRepository: Repository<Chamado>, eventEmitter: EventEmitter2, equipamentoRepository: Repository<Equipamento>, respostaChecklistRepository: Repository<RespostaChecklist>, respostaChecklistTecnicoRepository: Repository<RespostaChecklistTecnico>, checklistGateway: ChecklistGateway, userRepository: Repository<User>);
    abrir(dto: CreateChamadoDto, equipamentoId: number, currentUser: User, files?: Express.Multer.File[]): Promise<Chamado | null>;
    assinarChamado(chamadoId: number, currentUser: User, base64String: string): Promise<{
        message: string;
    }>;
    findAllChamados(currentUser: User): Promise<any[]>;
    findOne(id: number): Promise<any>;
    findAllOfUser(userId: number): Promise<{
        tecnico: {
            id: number;
            nome: string;
        } | null;
        user: {
            id: number;
            user: string;
        } | null;
        id: number;
        tipo: string;
        status: string;
        horaAbertura: Date;
        horaInicioAtendimento: Date;
        horaFinalizacao: Date;
        tempoDeRespostaMs: number;
        dataMarcada: Date;
        assinatura: string;
        atividade: string;
        equipamento: Equipamento;
        respostasChecklist: RespostaChecklist[];
        respostasChecklistTecnico: RespostaChecklistTecnico[];
        pontoColaborador: import("../colaborador/entities/colaborador.entity").Colaborador;
    }[]>;
    atribuirTecnico(chamadoID: number, tecnicoID: number, date: Date): Promise<Chamado>;
    atualizarPorCheck(equipamentoId: number, dto: CreateChamadoDto, currentUser: User, files?: Express.Multer.File[]): Promise<Chamado | null>;
    finalizarChamado(equipamentoId: number, currentUser: User, resumoData: string): Promise<"finalizado com sucesso, usuario precisa assinar" | undefined>;
    itensModal(equipamentoId: number): Promise<RespostaChecklistTecnico[]>;
    getCheckListTeck(equipamentoId: number): Promise<RespostaChecklistTecnico[]>;
    detalhesOsCliente(CurrentUser: User, osID: number): Promise<{
        id: number;
        status: string;
        horaAbertura: Date;
        razaoSocial: string;
        modeloCompressor: string;
        tecnicoName: string;
        midiasUser: string[];
        observacaoUser: string[];
        picoEnergia: true[];
        checklistsTecnico: {
            nome: string;
            estado: boolean;
            observacao: string;
            urlMedia: string | undefined;
            operacional: boolean;
        }[];
    }>;
    timeLine(CurrentUser: User, osId: number): Promise<{
        id: number;
        status: string;
        tipo: string;
        horaAbertura: Date;
        horaFinalizacao: Date;
        equipamento: {
            id: number;
            modelo: string;
        } | null;
        tecnico: {
            id: number;
            nome: string;
        } | null;
        respostasCliente: {
            observacao: string;
            midias: string[];
        }[];
        respostasTecnico: {
            nome: string;
            estado: boolean;
            observacao: string;
            operacional: boolean;
            midia: string | undefined;
        }[];
    }>;
    deletarOs(osId: number): Promise<{
        message: string;
    }>;
    uploadImageToS3(file: Express.Multer.File, fileName: string): Promise<string>;
}
