"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const user_entity_1 = require("./entities/user.entity");
const typeorm_2 = require("typeorm");
const jwt_1 = require("@nestjs/jwt");
const bcrypt = __importStar(require("bcrypt"));
const user_role_enum_1 = require("./user-role.enum");
let UserService = class UserService {
    usersRepository;
    jwtService;
    constructor(usersRepository, jwtService) {
        this.usersRepository = usersRepository;
        this.jwtService = jwtService;
    }
    async create(createUserDto) {
        const userExist = await this.usersRepository.findOne({
            where: {
                email: createUserDto.email,
            },
        });
        if (userExist) {
            throw new common_1.ConflictException('usuario ja existe');
        }
        const salt = await bcrypt.genSalt();
        const hashedPassword = await bcrypt.hash(createUserDto.password, salt);
        const newUser = this.usersRepository.create({
            ...createUserDto,
            password: hashedPassword,
        });
        const user = await this.usersRepository.save(newUser);
        const payload = { sub: user.id, email: user.email, role: user.role };
        const accessToken = this.jwtService.sign(payload);
        return { user, accessToken };
    }
    async update(id, updateUserDto) {
        const user = await this.usersRepository.preload({
            id: id,
            ...updateUserDto,
        });
        console.log(user);
        if (!user) {
            throw new common_1.NotFoundException(`Ops, o usuario com o id "${id}" não foi encontrado`);
        }
        if (updateUserDto.password) {
            const salt = await bcrypt.genSalt();
            user.password = await bcrypt.hash(updateUserDto.password, salt);
            console.log(user.password);
            return this.usersRepository.save(user);
        }
        return this.usersRepository.save(user);
    }
    async createTechnical(createTecnicoDto) {
        const existeTecnico = await this.usersRepository.findOne({
            where: {
                email: createTecnicoDto.email,
            },
        });
        if (existeTecnico) {
            throw new common_1.ConflictException('tecnico ja existe');
        }
        const salt = await bcrypt.genSalt();
        const hashedPassword = await bcrypt.hash(createTecnicoDto.password, salt);
        const newTecnico = this.usersRepository.create({
            ...createTecnicoDto,
            password: hashedPassword,
            role: user_role_enum_1.UserRole.TECHNICAL,
            registrationDate: new Date(),
        });
        const tecnico = await this.usersRepository.save(newTecnico);
        const payload = {
            sub: tecnico.id,
            email: tecnico.email,
            senha: tecnico.password,
            role: tecnico.role,
        };
        const accessToken = this.jwtService.sign(payload);
        return { tecnico, accessToken };
    }
    async createColaborator(createColaboratorDto) {
        const existeColaborador = await this.usersRepository.findOne({
            where: {
                email: createColaboratorDto.email,
            },
        });
        if (existeColaborador) {
            throw new common_1.ConflictException('Colaborador ja existe');
        }
        const salt = await bcrypt.genSalt();
        const hashedPassword = await bcrypt.hash(createColaboratorDto.password, salt);
        const newColaborador = this.usersRepository.create({
            ...createColaboratorDto,
            password: hashedPassword,
            role: user_role_enum_1.UserRole.TECHNICAL,
        });
        const colaborador = await this.usersRepository.save(newColaborador);
        const payload = {
            sub: colaborador.id,
            email: colaborador.email,
            senha: colaborador.password,
            role: colaborador.role,
        };
        const accessToken = this.jwtService.sign(payload);
        return { colaborador, accessToken };
    }
    async login(email, password) {
        const user = await this.usersRepository.findOne({
            where: { email },
        });
        if (user && (await bcrypt.compare(password, user.password))) {
            const payload = { sub: user.id, email: user.email, role: user.role };
            const accessToken = this.jwtService.sign(payload);
            return { user, accessToken };
        }
        throw new common_1.UnauthorizedException('Ops, senha ou e-mail estão incorretos');
    }
    remove(id) {
        return this.usersRepository.delete(id);
    }
    async getAllUsersClients() {
        return this.usersRepository
            .createQueryBuilder('user')
            .leftJoin('user.equipamentos', 'equipamento')
            .select([
            'user.id',
            'user.name',
            'user.email',
            'user.razaoSocial',
            'user.cnpj',
            'user.email',
            'user.telefone',
            'user.isActive',
            'user.requiresSubscription',
        ])
            .addSelect('COUNT(equipamento.id)', 'quantidadeEquipamentos')
            .where('user.role = :role', { role: user_role_enum_1.UserRole.COMMON_USER })
            .groupBy('user.id')
            .getRawMany();
    }
    async getAllUsersTechnical() {
        const tecnicos = await this.usersRepository.find({
            where: {
                role: user_role_enum_1.UserRole.TECHNICAL,
            },
            select: [
                'id',
                'name',
                'email',
                'isActive',
                'telefone',
                'workDays',
                'workShiftStart',
                'workShiftEnd',
            ],
        });
        return tecnicos;
    }
    async getAllUsersColaborator() {
        const colaboradores = await this.usersRepository.find({
            where: {
                role: user_role_enum_1.UserRole.TECHNICAL,
            },
            select: ['id', 'name', 'email', 'isActive', 'telefone'],
        });
        return colaboradores;
    }
    async getMe(id) {
        const user = await this.usersRepository.findOne({
            where: { id },
        });
        if (!user) {
            throw new common_1.NotFoundException(`Usuário com ID ${id} não foi encontrado.`);
        }
        const { password, ...result } = user;
        return result;
    }
};
exports.UserService = UserService;
exports.UserService = UserService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        jwt_1.JwtService])
], UserService);
//# sourceMappingURL=user.service.js.map