import { UserService } from './user.service';
import { CreateUserDto } from './dto/create-user.dto';
import { LoginDto } from './dto/login.dto';
import { UpdateUserDto } from './dto/update-user.dto';
import { User } from './entities/user.entity';
import { UserRole } from './user-role.enum';
import { CreateUserTechnicalDto } from './dto/create-tecnico.dto';
export declare class UserController {
    private readonly userService;
    constructor(userService: UserService);
    create(createUserDto: CreateUserDto): Promise<{
        user: User;
        accessToken: string;
    }>;
    createTechnical(createTecnicoDto: CreateUserTechnicalDto): Promise<{
        tecnico: User;
        accessToken: string;
    }>;
    createColaborator(createColaboratorDto: CreateUserTechnicalDto): Promise<{
        colaborador: User;
        accessToken: string;
    }>;
    login(loginDto: LoginDto): Promise<{
        user: User;
        accessToken: string;
    }>;
    getAllUsersClients(): Promise<any[]>;
    getAllUsersTechnical(): Promise<User[]>;
    getAllUsersColaborator(): Promise<User[]>;
    getMe(currentUser: User): Promise<{
        id: number;
        name: string;
        email: string;
        cnpj: string;
        razaoSocial: string;
        telefone: string;
        isActive: boolean;
        role: UserRole;
        requiresSubscription: boolean;
        workDays: string[];
        workShiftStart: string;
        workShiftEnd: string;
        registrationDate: Date;
        equipamentos: import("../equipamento/entities/equipamento.entity").Equipamento[];
        chamados: import("../chamado/entities/chamado.entity").Chamado[];
        registrosColaborador: import("../colaborador/entities/colaborador.entity").Colaborador[];
        colaboradoresDaEmpresa: import("../colaborador/entities/colaborador.entity").Colaborador[];
        despesas: import("../colaborador/entities/despesas.entity").Despesas[];
    }>;
    desativarUser(id: number): Promise<{
        message: string;
        user: User;
    }>;
    ativarUser(id: number): Promise<{
        message: string;
        user: User;
    }>;
    update(id: string, updateUserDto: UpdateUserDto): Promise<User>;
    remove(id: string): Promise<import("typeorm").DeleteResult>;
}
