"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EquipamentoService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const equipamento_entity_1 = require("./entities/equipamento.entity");
const user_entity_1 = require("../user/entities/user.entity");
const user_role_enum_1 = require("../user/user-role.enum");
const QRCode = __importStar(require("qrcode"));
const equipamento_role_enum_1 = require("./equipamento-role.enum");
require("dotenv/config");
const chamado_entity_1 = require("../chamado/entities/chamado.entity");
const resposta_checklist_tecnico_entity_1 = require("../chamado/entities/resposta-checklist-tecnico.entity");
let EquipamentoService = class EquipamentoService {
    equipamentoRepository;
    userRepository;
    chamadoRepository;
    checklistTecnicoRepository;
    async create(createEquipamentoDto) {
        const { user: userId, ...equipamentoData } = createEquipamentoDto;
        let user = null;
        if (userId) {
            user = await this.userRepository.findOne({ where: { id: userId } });
            if (!user) {
                throw new common_1.NotFoundException(`Usuário com ID ${userId} não encontrado.`);
            }
        }
        const novoEquipamento = this.equipamentoRepository.create({
            ...equipamentoData,
            user: user,
        });
        await this.equipamentoRepository.save(novoEquipamento);
        return novoEquipamento;
    }
    async findAll(currentUser) {
        if (currentUser.role === user_role_enum_1.UserRole.ADMIN) {
            const equipamentos = await this.equipamentoRepository
                .createQueryBuilder('equipamento')
                .leftJoinAndSelect('equipamento.user', 'user')
                .leftJoinAndSelect('equipamento.chamados', 'chamado')
                .select([
                'equipamento.id',
                'equipamento.modeloCompressor',
                'equipamento.tensao',
                'equipamento.tipoGas',
                'equipamento.tipoValvula',
                'equipamento.tipoCondensador',
                'equipamento.tipoEvaporador',
                'equipamento.tipoOleo',
                'equipamento.aplicacao',
                'equipamento.status',
                'equipamento.isAtivo',
                'user.id',
                'user.name',
                'chamado.id',
                'chamado.tipo',
                'chamado.status',
                'chamado.dataMarcada',
                'chamado.horaAbertura',
                'chamado.horaInicioAtendimento',
                'chamado.horaFinalizacao',
                'chamado.tempoDeRespostaMs',
            ])
                .getMany();
            return equipamentos;
        }
        else if (currentUser.role === user_role_enum_1.UserRole.TECHNICAL) {
            const equipamentos = await this.equipamentoRepository
                .createQueryBuilder('equipamento')
                .leftJoinAndSelect('equipamento.user', 'user')
                .leftJoinAndSelect('equipamento.chamados', 'chamado')
                .where('( (chamado.status = :aberto OR chamado.status = :andamento) AND chamado.tecnicoId = :id  AND chamado.horaFinalizacao IS NULL)', {
                aberto: 'Aberto',
                andamento: 'Em andamento',
                id: currentUser.id,
            })
                .select([
                'equipamento.id',
                'equipamento.modeloCompressor',
                'equipamento.tensao',
                'equipamento.tipoGas',
                'equipamento.tipoOleo',
                'equipamento.aplicacao',
                'equipamento.status',
                'user.id',
                'user.name',
                'chamado.id',
                'chamado.tipo',
                'chamado.status',
                'chamado.horaAbertura',
                'chamado.horaInicioAtendimento',
                'chamado.horaFinalizacao',
                'chamado.tempoDeRespostaMs',
            ])
                .getMany();
            return equipamentos;
        }
        else if (currentUser.role === user_role_enum_1.UserRole.COMMON_USER) {
            const equipamentos = await this.equipamentoRepository
                .createQueryBuilder('equipamento')
                .leftJoinAndSelect('equipamento.user', 'user')
                .leftJoinAndSelect('equipamento.chamados', 'chamado')
                .where('equipamento.userId = :userId', { userId: currentUser.id })
                .select([
                'equipamento.id',
                'equipamento.modeloCompressor',
                'equipamento.tensao',
                'equipamento.tipoGas',
                'equipamento.tipoOleo',
                'equipamento.aplicacao',
                'equipamento.status',
                'user.id',
                'user.name',
                'user.cnpj',
                'user.razaoSocial',
                'user.requiresSubscription',
                'chamado.id',
                'chamado.tipo',
                'chamado.status',
                'chamado.horaFinalizacao',
            ])
                .getMany();
            return equipamentos;
        }
    }
    async findOne(id) {
        const equipamento = await this.equipamentoRepository.findOne({
            where: { id },
            relations: ['chamados', 'user', 'chamados.tecnico'],
        });
        if (!equipamento) {
            throw new common_1.NotFoundException(`Equipamento com ID ${id} não encontrado.`);
        }
        const chamadoAberto = equipamento.chamados?.find((c) => c.status !== 'Finalizado' && c.status !== 'Cancelado');
        const { chamados, ...rest } = equipamento;
        const chamadosFechados = equipamento.chamados
            ?.filter((c) => c.status === 'Finalizado' || c.status === 'Cancelado')
            .map((c) => ({
            id: c.id,
            tipo: c.tipo,
            status: c.status,
            horaAbertura: c.horaAbertura,
            horaInicioAtendimento: c.horaInicioAtendimento,
            horaFinalizacao: c.horaFinalizacao,
            tecnico: c.tecnico
                ? {
                    name: c.tecnico.name,
                }
                : null,
        }));
        return {
            ...rest,
            chamadoAberto: {
                id: chamadoAberto?.id,
                horaAtendimento: chamadoAberto?.horaInicioAtendimento,
                horaFinalizacao: chamadoAberto?.horaFinalizacao,
            },
            chamadosFechados: chamadosFechados || null,
        };
    }
    async findByUser(userid) {
        const equipamentos = await this.equipamentoRepository.find({
            where: { user: { id: userid } },
        });
        return equipamentos;
    }
    async updateRealTime(id) {
        const checklists = await this.checklistTecnicoRepository.find({
            where: {
                chamado: {
                    status: 'Em Andamento',
                    equipamento: {
                        id: id,
                        status: equipamento_role_enum_1.EquipamentoStatus.MANUTENCAO,
                    },
                },
            },
            select: {
                id: true,
                nomeChecklist: true,
                estado: true,
                observacao: true,
                operacional: true,
                urlMedia: true,
            },
            order: {
                id: 'ASC',
            },
        });
        if (!checklists || checklists.length === 0) {
            throw new common_1.NotFoundException(`Nenhuma checklist encontrada para o equipamento ${id}.`);
        }
        return checklists;
    }
    async update(id, updateEquipamentoDto) {
        const { user: userId, ...equipamentoData } = updateEquipamentoDto;
        const dataToUpdate = { ...equipamentoData };
        if (userId) {
            dataToUpdate.user = { id: userId };
        }
        return this.equipamentoRepository.update(id, dataToUpdate);
    }
    remove(id) {
        return this.equipamentoRepository.delete(id);
    }
    async generateQRCode(id) {
        const existEquipamento = await this.equipamentoRepository.findOne({
            where: { id },
        });
        if (!existEquipamento) {
            throw new common_1.NotFoundException('Não é possível gerar QR Code para equipamento inexistente.');
        }
        const frontEndUrl = `https://mgrrefrigeracao.com.br/equipamento/?id=${id}`;
        const qrcodeBuffer = await QRCode.toDataURL(frontEndUrl);
        existEquipamento.qrcode = qrcodeBuffer;
        await this.equipamentoRepository.save(existEquipamento);
        return qrcodeBuffer;
    }
    async historico(id, correntUser) {
        const existEquipamento = await this.equipamentoRepository.findOne({
            where: { id },
        });
        if (!existEquipamento) {
            throw new common_1.NotFoundException('Não foi possivel localizar o historico do equipamento.');
        }
        if (correntUser.role === user_role_enum_1.UserRole.ADMIN ||
            correntUser.role === user_role_enum_1.UserRole.TECHNICAL) {
            const historico = await this.chamadoRepository
                .createQueryBuilder('chamado')
                .leftJoinAndSelect('chamado.equipamento', 'equipamento')
                .leftJoinAndSelect('chamado.user', 'user')
                .leftJoinAndSelect('chamado.tecnico', 'tecnico')
                .where('equipamento.id = :id', { id: id })
                .select([
                'chamado.id',
                'chamado.tipo',
                'chamado.status',
                'chamado.horaAbertura',
                'user.name',
                'user.requiresSubscription',
                'tecnico.name',
                'chamado.horaInicioAtendimento',
                'chamado.horaFinalizacao',
                'chamado.assinatura',
            ])
                .orderBy('chamado.horaAbertura', 'DESC')
                .getMany();
            return historico;
        }
        else {
            const historico = await this.chamadoRepository
                .createQueryBuilder('chamado')
                .leftJoin('chamado.tecnico', 'tecnico')
                .select([
                'chamado.id',
                'chamado.tipo',
                'chamado.status',
                'chamado.horaAbertura',
                'tecnico.name',
            ])
                .orderBy('chamado.horaAbertura', 'DESC')
                .getMany();
            return historico;
        }
    }
    async ativar(id) {
        const equipamento = await this.equipamentoRepository.findOne({
            where: { id: id, isAtivo: false },
        });
        if (!equipamento) {
            throw new common_1.NotFoundException(`Equipamento com ID ${id} não encontrado.`);
        }
        await this.equipamentoRepository.update(id, { isAtivo: true });
    }
    async desativar(id) {
        const equipamento = await this.equipamentoRepository.findOne({
            where: { id: id, isAtivo: true },
        });
        if (!equipamento) {
            throw new common_1.NotFoundException(`Equipamento com ID ${id} não encontrado.`);
        }
        await this.equipamentoRepository.update(id, { isAtivo: false });
    }
};
exports.EquipamentoService = EquipamentoService;
__decorate([
    (0, typeorm_1.InjectRepository)(equipamento_entity_1.Equipamento),
    __metadata("design:type", typeorm_2.Repository)
], EquipamentoService.prototype, "equipamentoRepository", void 0);
__decorate([
    (0, typeorm_1.InjectRepository)(user_entity_1.User),
    __metadata("design:type", typeorm_2.Repository)
], EquipamentoService.prototype, "userRepository", void 0);
__decorate([
    (0, typeorm_1.InjectRepository)(chamado_entity_1.Chamado),
    __metadata("design:type", typeorm_2.Repository)
], EquipamentoService.prototype, "chamadoRepository", void 0);
__decorate([
    (0, typeorm_1.InjectRepository)(resposta_checklist_tecnico_entity_1.RespostaChecklistTecnico),
    __metadata("design:type", typeorm_2.Repository)
], EquipamentoService.prototype, "checklistTecnicoRepository", void 0);
exports.EquipamentoService = EquipamentoService = __decorate([
    (0, common_1.Injectable)()
], EquipamentoService);
//# sourceMappingURL=equipamento.service.js.map