import { Repository } from 'typeorm';
import { Chamado } from 'src/chamado/entities/chamado.entity';
import { Equipamento } from 'src/equipamento/entities/equipamento.entity';
import { RespostaChecklist } from 'src/chamado/entities/resposta-checklist.entity';
import { User } from 'src/user/entities/user.entity';
import { RespostaChecklistTecnico } from 'src/chamado/entities/resposta-checklist-tecnico.entity';
export declare class DashboardService {
    private chamadoRepository;
    private equipamentoRepository;
    private respostaChecklistRepository;
    private userRepository;
    private respostaChecklistTecnicoRepository;
    constructor(chamadoRepository: Repository<Chamado>, equipamentoRepository: Repository<Equipamento>, respostaChecklistRepository: Repository<RespostaChecklist>, userRepository: Repository<User>, respostaChecklistTecnicoRepository: Repository<RespostaChecklistTecnico>);
    CountEquipament(currentUser: User): Promise<{
        equipamentosDisponiveis: number;
        equipamentosEmManutencao: number;
    }>;
    chamadosPendentes(currentUser: User): Promise<any[]>;
    typeChamado(currentUser: User): Promise<never[]>;
    atividadeTecnicoEsseMes(): Promise<{
        name: any;
        finalizados: number;
        emAndamento: number;
        total: number;
        taxaSucesso: string;
    }[]>;
    atividadeTecnicoSeisMeses(): Promise<never[]>;
    osPendente(): Promise<any[]>;
    totalCliente(): Promise<number>;
    totalTecnico(): Promise<number>;
    totalOsPendente(): Promise<number>;
    totalEquipamentosMonitorados(): Promise<number>;
    chamadoPorTipoDeEquipamento(): Promise<any[]>;
    atividadeTecnicoSeteDias(currentUser: User): Promise<never>;
    maquinasTecnico(currentUser: User): Promise<any[]>;
    atividadeRecente(currentUser: User): Promise<any[]>;
}
