"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColaboradorService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const colaborador_entity_1 = require("./entities/colaborador.entity");
const user_entity_1 = require("../user/entities/user.entity");
const registroColaborador_entity_1 = require("./entities/registroColaborador.entity");
const client_s3_1 = require("@aws-sdk/client-s3");
const despesas_entity_1 = require("./entities/despesas.entity");
const user_role_enum_1 = require("../user/user-role.enum");
const visitaAgendada_entity_1 = require("./entities/visitaAgendada.entity");
const equipamento_service_1 = require("../equipamento/equipamento.service");
const chamado_entity_1 = require("../chamado/entities/chamado.entity");
let ColaboradorService = class ColaboradorService {
    colaboradorRepository;
    registrosColaboradorRepository;
    despesasRepository;
    visitaAgendadaRepository;
    chamadoRepository;
    userRepository;
    equipamentoService;
    s3;
    constructor(colaboradorRepository, registrosColaboradorRepository, despesasRepository, visitaAgendadaRepository, chamadoRepository, userRepository, equipamentoService) {
        this.colaboradorRepository = colaboradorRepository;
        this.registrosColaboradorRepository = registrosColaboradorRepository;
        this.despesasRepository = despesasRepository;
        this.visitaAgendadaRepository = visitaAgendadaRepository;
        this.chamadoRepository = chamadoRepository;
        this.userRepository = userRepository;
        this.equipamentoService = equipamentoService;
        {
            this.s3 = new client_s3_1.S3Client({
                region: process.env.AWS_S3_REGION,
            });
        }
    }
    async create(currentUser) {
        const colaborador = await this.colaboradorRepository.findOne({
            where: {
                user: { id: currentUser.id },
            },
            order: {
                id: 'DESC',
            },
        });
        const finalizado = colaborador?.saida;
        if (!colaborador || finalizado) {
            const colaborador = this.colaboradorRepository.create({
                entrada: new Date(),
                user: currentUser,
            });
            return this.colaboradorRepository.save(colaborador);
        }
    }
    async findAll(date) {
        const query = this.colaboradorRepository
            .createQueryBuilder('colaborador')
            .leftJoin('colaborador.user', 'user')
            .leftJoin('chamado', 'chamado', 'chamado.tecnicoId = user.id AND chamado.pontoColaboradorId = colaborador.id AND chamado.status = :status', { status: 'Finalizado' })
            .leftJoin('chamado.user', 'empresa')
            .select([
            'colaborador.id AS id',
            'user.name AS name',
            'user.email AS email',
            'user.id AS "userId"',
            'colaborador.entrada AS entrada',
            'colaborador.almoco AS almoco',
            'colaborador.retornoAlmoço AS retornoAlmoco',
            'colaborador.saida AS saida',
        ])
            .addSelect(`
      CASE
        WHEN chamado.horaAbertura IS NOT NULL
         AND chamado.horaFinalizacao IS NULL
        THEN true
        ELSE false
      END
      `, 'externo')
            .addSelect([
            'chamado.id AS chamadoId',
            'chamado.pontoColaboradorId AS idPonto',
            'chamado.tipo AS atividade',
            'empresa.name AS empresa',
            'chamado.horaAbertura AS inicio',
        ]);
        if (date) {
            const start = `${date} 00:00:00`;
            const end = `${date} 23:59:59`;
            query.where('colaborador.entrada BETWEEN :start AND :end', {
                start,
                end,
            });
        }
        const rows = await query.getRawMany();
        const resultado = rows.reduce((acc, row) => {
            let colaborador = acc.find((c) => c.id === row.id);
            if (!colaborador) {
                colaborador = {
                    id: row.id,
                    name: row.name,
                    email: row.email,
                    userId: row.userId,
                    entrada: row.entrada,
                    almoco: row.almoco,
                    retornoAlmoco: row.retornoAlmoco,
                    saida: row.saida,
                    externo: Boolean(Number(row.externo)),
                    chamados: [],
                };
                acc.push(colaborador);
            }
            if (row.chamadoId) {
                colaborador.chamados.push({
                    id: row.chamadoId,
                    atividade: row.atividade,
                    empresa: row.empresa,
                    inicio: row.inicio,
                    ponto: row.idPonto,
                });
            }
            return acc;
        }, []);
        return resultado;
    }
    findOne(id) {
        return this.colaboradorRepository.findOne({
            where: { id },
        });
    }
    async update(id, updateColaboradorDto) {
        const colaborador = await this.colaboradorRepository.findOne({
            where: {
                id: id,
            },
        });
        if (!colaborador) {
            throw new Error('Atividade não encontrada');
        }
        return this.colaboradorRepository.update(id, updateColaboradorDto);
    }
    async registroColaborador(id, updateColaboradorDto, file) {
        const colaborador = await this.colaboradorRepository.findOne({
            where: { id },
            relations: ['user'],
        });
        if (!colaborador) {
            throw new Error('Colaborador não encontrado');
        }
        const registroPendente = await this.registrosColaboradorRepository.findOne({
            where: {
                finalizacao: (0, typeorm_2.IsNull)(),
                colaborador: { id },
            },
        });
        if (registroPendente) {
            this.registrosColaboradorRepository.merge(registroPendente, updateColaboradorDto);
            if (file) {
                try {
                    const uniqueFileName = `${Date.now()}-${'98352uojie'}`;
                    const url = await this.uploadImageToS3(file, uniqueFileName);
                    registroPendente.urlArquivo = url;
                    return await this.registrosColaboradorRepository.save(registroPendente);
                }
                catch (error) {
                    console.log(error);
                }
            }
            return await this.registrosColaboradorRepository.save(registroPendente);
        }
        const novoRegistro = this.registrosColaboradorRepository.create({
            ...updateColaboradorDto,
            colaborador,
            inicio: new Date(),
            empresa: updateColaboradorDto.empresaId
                ? { id: updateColaboradorDto.empresaId }
                : undefined,
        });
        return await this.registrosColaboradorRepository.save(novoRegistro);
    }
    remove(id) {
        return this.colaboradorRepository.delete(id);
    }
    async linhaTempo(id) {
        const colaborador = await this.colaboradorRepository.findOne({
            where: { user: { id } },
            relations: ['user', 'registroDoColaborador'],
            order: {
                id: 'DESC',
            },
        });
        return colaborador;
    }
    async pontoColaborador(currentUser) {
        console.log(currentUser);
        const colaborador = await this.colaboradorRepository.find({
            where: {
                user: { id: currentUser.id },
                entrada: (0, typeorm_2.Not)((0, typeorm_2.IsNull)()),
                saida: (0, typeorm_2.Not)((0, typeorm_2.IsNull)()),
            },
        });
        return colaborador;
    }
    async historicoPonto(currentUser) {
        console.log(currentUser);
        const historico = await this.colaboradorRepository.find({
            where: { user: { id: currentUser.id } },
        });
        if (!historico) {
            throw new Error('Nenhum registro encontrado');
        }
        return historico;
    }
    async historicoPontoAdmin(id) {
        const user = await this.userRepository.findOne({
            where: { id },
        });
        const rows = await this.colaboradorRepository
            .createQueryBuilder('colaborador')
            .leftJoin('colaborador.user', 'user')
            .leftJoin('chamado', 'chamado', `
    chamado.tecnicoId = user.id
    AND chamado.horaAbertura >= colaborador.entrada
    AND (
      colaborador.saida IS NULL
      OR chamado.horaAbertura <= colaborador.saida
    )
  `)
            .leftJoin('chamado.user', 'empresa')
            .select([
            'colaborador.id AS id',
            'user.name AS name',
            'user.email AS email',
            'user.id AS "userId"',
            'colaborador.entrada AS entrada',
            'colaborador.almoco AS almoco',
            'colaborador.retornoAlmoço AS retornoAlmoco',
            'colaborador.saida AS saida',
        ])
            .addSelect([
            'chamado.id AS chamadoId',
            'chamado.tipo AS atividade',
            'empresa.name AS empresa',
            'chamado.horaAbertura AS inicio',
        ])
            .where('colaborador.user = :id', { id })
            .orderBy('colaborador.id', 'DESC')
            .getRawMany();
        if (!rows.length) {
            throw new Error('Nenhum registro encontrado');
        }
        const resultado = rows.reduce((acc, row) => {
            let colaborador = acc.find((c) => c.id === row.id);
            if (!colaborador) {
                colaborador = {
                    id: row.id,
                    name: row.name,
                    email: row.email,
                    userId: row.userId,
                    entrada: row.entrada,
                    almoco: row.almoco,
                    retornoAlmoco: row.retornoAlmoco,
                    saida: row.saida,
                    chamados: [],
                };
                acc.push(colaborador);
            }
            if (row.chamadoId) {
                colaborador.chamados.push({
                    id: row.chamadoId,
                    atividade: row.atividade,
                    empresa: row.empresa,
                    inicio: row.inicio,
                });
            }
            return acc;
        }, []);
        return {
            user,
            resultado,
        };
    }
    async despesas(createDespesasDto, currentUser, file) {
        const existColaborador = await this.colaboradorRepository.findOne({
            where: { user: { id: currentUser.id } },
        });
        if (!existColaborador) {
            throw new Error('Colaborador não encontrado');
        }
        const userId = currentUser.id;
        if (file) {
            const uniqueFileName = `${Date.now()}-18471hdsa`;
            const url = await this.uploadImageToS3(file, uniqueFileName);
            createDespesasDto.urlArquivo = url;
        }
        const despesa = this.despesasRepository.create({
            ...createDespesasDto,
            data: new Date(),
            status: 'Pendente',
            user: { id: userId },
        });
        return this.despesasRepository.save(despesa);
    }
    async getDespesas(currentUser) {
        const userId = currentUser.id;
        if (currentUser.role === user_role_enum_1.UserRole.ADMIN) {
            const despesas = await this.despesasRepository.find({
                relations: ['user'],
            });
            const despesaFormat = despesas.map((despesa) => ({
                ...despesa,
                user: despesa.user.name,
                email: despesa.user.email,
            }));
            return despesaFormat;
        }
        const despesas = await this.despesasRepository.find({
            where: { user: { id: userId } },
        });
        if (!despesas) {
            throw new Error('Nenhuma despesa encontrada');
        }
        return despesas;
    }
    async aprovarDespesa(id) {
        const despesa = await this.despesasRepository.findOne({
            where: { id },
        });
        if (!despesa) {
            throw new Error('Despesa não encontrada');
        }
        despesa.status = 'Aprovada';
        return this.despesasRepository.save(despesa);
    }
    async rejeitarDespesa(id) {
        const despesa = await this.despesasRepository.findOne({
            where: { id },
        });
        if (!despesa) {
            throw new Error('Despesa não encontrada');
        }
        despesa.status = 'Rejeitada';
        return this.despesasRepository.save(despesa);
    }
    async criarVisita(tecnicoId, equipamentoId, createColaboradorDto) {
        const agendamentoExiste = await this.chamadoRepository.findOneBy({
            equipamento: { id: equipamentoId },
            dataMarcada: createColaboradorDto.dataMarcada,
        });
        if (agendamentoExiste) {
            throw new common_1.ConflictException(`Ja possui um agendamento para esse equipamento na data ${createColaboradorDto.dataMarcada}`);
        }
        const empresaDoEquipamento = await this.equipamentoService.findOne(equipamentoId);
        const empresaId = empresaDoEquipamento.user?.id;
        const criarAgendamento = this.chamadoRepository.create({
            ...createColaboradorDto,
            user: empresaId ? { id: empresaId } : undefined,
            tecnico: { id: tecnicoId },
            equipamento: { id: equipamentoId },
            horaAbertura: new Date(),
        });
        return this.chamadoRepository.save(criarAgendamento);
    }
    async atualizarVisita(chamadoId, tecnicoId, equipamentoId, updateColaboradorDto) {
        const chamadoExistente = await this.chamadoRepository.findOne({
            where: { id: chamadoId },
            relations: ['equipamento', 'tecnico'],
        });
        if (!chamadoExistente) {
            throw new common_1.NotFoundException('Agendamento não encontrado');
        }
        if (updateColaboradorDto.dataMarcada &&
            updateColaboradorDto.dataMarcada !== chamadoExistente.dataMarcada) {
            const agendamentoExiste = await this.chamadoRepository.findOne({
                where: {
                    equipamento: { id: equipamentoId },
                    dataMarcada: updateColaboradorDto.dataMarcada,
                },
            });
        }
        const empresaDoEquipamento = await this.equipamentoService.findOne(equipamentoId);
        const empresaId = empresaDoEquipamento.user?.id;
        const tecnicoFoiAlterado = chamadoExistente.tecnico?.id !== tecnicoId;
        this.chamadoRepository.merge(chamadoExistente, {
            ...updateColaboradorDto,
            user: empresaId ? { id: empresaId } : undefined,
            tecnico: { id: tecnicoId },
            equipamento: { id: equipamentoId },
            ...(tecnicoFoiAlterado && {
                horaInicioAtendimento: '',
                horaFinalizacao: '',
            }),
        });
        return this.chamadoRepository.save(chamadoExistente);
    }
    async iniciarVisitaAgendada(currentUser, chamadoId) {
        const colaboradorOpen = await this.colaboradorRepository.findOne({
            where: {
                user: { id: currentUser.id },
                entrada: (0, typeorm_2.Not)((0, typeorm_2.IsNull)()),
                saida: (0, typeorm_2.IsNull)(),
            },
        });
        if (!colaboradorOpen) {
            throw new common_1.BadRequestException('É necessário iniciar o dia de trabalho antes de iniciar um serviço.');
        }
        if (colaboradorOpen.almoco !== null &&
            colaboradorOpen.retornoAlmoço === null) {
            throw new common_1.BadRequestException('O colaborador ainda está em horário de almoço.');
        }
        this.chamadoRepository.update(chamadoId, {
            status: 'Em andamento',
            horaInicioAtendimento: new Date(),
            pontoColaborador: { id: colaboradorOpen.id },
        });
    }
    async getVisitaAgendada(CurrentUser) {
        const userId = CurrentUser.id;
        if (CurrentUser.role === user_role_enum_1.UserRole.ADMIN) {
            const visitas = await this.visitaAgendadaRepository.find({
                relations: ['empresa', 'user'],
            });
            const visitasFormat = visitas.map((visita) => ({
                ...visita,
                user: visita.user.name,
                email: visita.user.email,
                empresa: visita.empresa.name,
            }));
            return visitasFormat;
        }
        else {
            const visitas = await this.visitaAgendadaRepository.find({
                where: { user: { id: userId } },
                relations: ['empresa'],
            });
            const visitasFormat = visitas.map((visitas) => ({
                ...visitas,
                empresa: visitas.empresa.name,
            }));
            return visitasFormat;
        }
    }
    async uploadImageToS3(file, fileName) {
        if (!file || !file.mimetype) {
            throw new common_1.BadRequestException('Arquivo inválido');
        }
        const region = process.env.AWS_S3_REGION;
        const bucket = process.env.AWS_S3_BUCKET;
        const ext = file.mimetype.split('/')[1];
        const uniqueName = `${fileName}-${Date.now()}.${ext}`;
        const command = new client_s3_1.PutObjectCommand({
            Bucket: bucket,
            Key: uniqueName,
            Body: file.buffer,
            ContentType: file.mimetype,
            ContentDisposition: 'inline',
        });
        await this.s3.send(command);
        return `https://${bucket}.s3.${region}.amazonaws.com/${uniqueName}`;
    }
};
exports.ColaboradorService = ColaboradorService;
exports.ColaboradorService = ColaboradorService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(colaborador_entity_1.Colaborador)),
    __param(1, (0, typeorm_1.InjectRepository)(registroColaborador_entity_1.RegistrosColaborador)),
    __param(2, (0, typeorm_1.InjectRepository)(despesas_entity_1.Despesas)),
    __param(3, (0, typeorm_1.InjectRepository)(visitaAgendada_entity_1.VisitaAgendada)),
    __param(4, (0, typeorm_1.InjectRepository)(chamado_entity_1.Chamado)),
    __param(5, (0, typeorm_1.InjectRepository)(user_entity_1.User)),
    __metadata("design:paramtypes", [typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        typeorm_2.Repository,
        equipamento_service_1.EquipamentoService])
], ColaboradorService);
//# sourceMappingURL=colaborador.service.js.map