import { ChamadoService } from './chamado.service';
import { User } from 'src/user/entities/user.entity';
export declare class ChamadoController {
    private readonly chamadoService;
    constructor(chamadoService: ChamadoService);
    abrirChamado(data: string, equipamentoId: number, currentUser: User, files?: Express.Multer.File[]): Promise<import("./entities/chamado.entity").Chamado | null>;
    assinarChamado(chamadoId: string, currentUser: User, body: {
        assinatura: string;
    }): Promise<{
        message: string;
    }>;
    atribuirTecnico(tecnicoID: number, chamadoID: number, data: {
        date: Date;
    }): Promise<import("./entities/chamado.entity").Chamado>;
    atualizarPorCheck(equipamentoId: number, data: string, currentUser: User, files?: Express.Multer.File[]): Promise<import("./entities/chamado.entity").Chamado | null>;
    finalizarChamado(equipamentoId: number, CurrentUser: User, ResumoData: string): Promise<"finalizado com sucesso, usuario precisa assinar" | undefined>;
    itensModal(equipamentoId: number): Promise<import("./entities/resposta-checklist-tecnico.entity").RespostaChecklistTecnico[]>;
    getCheckListTeck(equipamentoId: number): Promise<import("./entities/resposta-checklist-tecnico.entity").RespostaChecklistTecnico[]>;
    detalhesOsCliente(currentUser: User, osId: number): Promise<{
        detalhes: {
            id: number;
            status: string;
            horaAbertura: Date;
            razaoSocial: string;
            modeloCompressor: string;
            tecnicoName: string;
            midiasUser: string[];
            observacaoUser: string[];
            picoEnergia: true[];
            checklistsTecnico: {
                nome: string;
                estado: boolean;
                observacao: string;
                urlMedia: string | undefined;
                operacional: boolean;
            }[];
        };
        timeLine: {
            id: number;
            status: string;
            tipo: string;
            horaAbertura: Date;
            horaFinalizacao: Date;
            equipamento: {
                id: number;
                modelo: string;
            } | null;
            tecnico: {
                id: number;
                nome: string;
            } | null;
            respostasCliente: {
                observacao: string;
                midias: string[];
            }[];
            respostasTecnico: {
                nome: string;
                estado: boolean;
                observacao: string;
                operacional: boolean;
                midia: string | undefined;
            }[];
        };
    }>;
    findAll(currentUser: User): Promise<any[]>;
    findOne(id: string): Promise<any>;
    findAllOfUser(userId: string): Promise<{
        tecnico: {
            id: number;
            nome: string;
        } | null;
        user: {
            id: number;
            user: string;
        } | null;
        id: number;
        tipo: string;
        status: string;
        horaAbertura: Date;
        horaInicioAtendimento: Date;
        horaFinalizacao: Date;
        tempoDeRespostaMs: number;
        dataMarcada: Date;
        assinatura: string;
        atividade: string;
        equipamento: import("../equipamento/entities/equipamento.entity").Equipamento;
        respostasChecklist: import("./entities/resposta-checklist.entity").RespostaChecklist[];
        respostasChecklistTecnico: import("./entities/resposta-checklist-tecnico.entity").RespostaChecklistTecnico[];
        pontoColaborador: import("../colaborador/entities/colaborador.entity").Colaborador;
    }[]>;
    remove(id: string): Promise<{
        message: string;
    }>;
}
